<?php

class Encryption{
	private $key = '';
	private $cipher = 'AES-256-CBC';
	private $iv = '';

    public function __construct($key){
    	if (!$key) {
    		throw new \Exception('key not found', 500);
    	}else{
    		$this->iv = openssl_random_pseudo_bytes(openssl_cipher_iv_length($this->cipher));
			$this->key = (hash('sha512', $key));
    	}
    }

    public function encrypt($data){
        return base64_encode(openssl_encrypt(http_build_query($data), $this->cipher, $this->key, 0, $this->iv).'&&'.bin2hex($this->iv));
    }

    public function decrypt($token){
        $token = base64_decode($token);
        list($token, $this->iv) = explode('&&', $token);
        $decoded_string =  openssl_decrypt($token, $this->cipher, $this->key, 0, hex2bin($this->iv));
		parse_str(html_entity_decode($decoded_string), $output);
        return $output;
    }
}