<?php

/**
 * The public-facing functionality of the plugin.
 *
 * @link       none
 * @since      1.0.0
 *
 * @package    Slms_Sso
 * @subpackage Slms_Sso/public
 */

/**
 * The public-facing functionality of the plugin.
 *
 * Defines the plugin name, version, and two examples hooks for how to
 * enqueue the public-facing stylesheet and JavaScript.
 *
 * @package    Slms_Sso
 * @subpackage Slms_Sso/public
 * @author     Art Dingal <artdingal@bitkea.com>
 */
class Slms_Sso_Ws {

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $plugin_name;

	/**
	 * The version of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $version    The current version of this plugin.
	 */
	private $version;

	/**
	 * The ID of this plugin.
	 *
	 * @since    1.0.0
	 * @access   private
	 * @var      string    $plugin_name    The ID of this plugin.
	 */
	private $lms_plugin_path = '/auth/slmswpsso/wplms.php';

	private $lms_url;
	private $secretkey;
	private $wstoken;
	private $redirecturl;

	/**
	 * Initialize the class and set its properties.
	 *
	 * @since    1.0.0
	 * @param      string    $plugin_name       The name of the plugin.
	 * @param      string    $version    The version of this plugin.
	 */
	public function __construct( $plugin_name, $version ) {

		$this->plugin_name = $plugin_name;
		$this->version = $version;
		$this->lms_url = get_option('slmssso_lms_url');
		$this->secretkey = get_option('slmssso_secret_key');
		$this->wstoken = get_option('slmssso_ws_token');
		$this->redirecturl = get_option('slmssso_redirect_url');
	}

	/**
	 * Performs webservice call to lms
	 * 
	 * @since    1.0.0
	 */
	public function call( $key = '', $request_param = array() ) {
	    $response = null;
	    $function_name = "";
	    $wsfunctions = array( 
	        'request_login_url' => 'auth_slmswpsso_request_login_url',
	        'request_user_fields' => 'auth_slmswpsso_profile_fields',
	        'get_users_without_uid' => 'auth_slmswpsso_get_users_without_uid',
            'update_user_uid'    => 'auth_slmswpsso_update_user_uid'
	    );

	    if ( array_key_exists( $key, $wsfunctions ) ) {
	      $function_name = $wsfunctions[ $key ];
	    }

	    $url = rtrim($this->lms_url,'/');
	    $token = $this->wstoken;

	    $request_url = $url . '/webservice/rest/server.php?wstoken=' . $token . '&wsfunction=' . $function_name . '&moodlewsrestformat=json';

	    if ( ! empty( $url )  && ! empty( $token ) && $function_name != '' ) {
	      $request_query = http_build_query( $request_param );
	      $response = wp_remote_post( $request_url, array( 'body' => $request_query ) );
	    } 
	    
	    if ( ! is_wp_error( $response ) && $response != null && $response[ 'response' ][ 'code' ] == 200 ) {
	      if ( is_string( $response[ 'body' ] ) ) {
	        $response_arr = json_decode( $response[ 'body' ], true );        
	        if ( json_last_error() === JSON_ERROR_NONE ) {
	          if ( is_null( $response_arr ) || ! array_key_exists( 'exception', $response_arr ) ) {
	            $has_error = false;
	            return $response_arr;
	          } else { $has_error = true; }
	        } else { $has_error = true; }
	      } else { $has_error = true; }
	    } else { $has_error = true; }    
	    return null;
	}
}
