<?php

/**
 * The plugin bootstrap file
 *
 * This file is read by WordPress to generate the plugin information in the plugin
 * admin area. This file also includes all of the dependencies used by the plugin,
 * registers the activation and deactivation functions, and defines a function
 * that starts the plugin.
 *
 * @link              none
 * @since             1.0.0
 * @package           Slms_Sso
 *
 * @wordpress-plugin
 * Plugin Name:       WP ScholarLMS SSO
 * Plugin URI:        https://www.scholarlms.com/docs/wordpress-integration/
 * Description:       This plugin enabled one way SSO integration from WP to ScholarLMS site.
 * Version:           3.0.0
 * Author:            ScholarLMS
 * Author URI:        https://www.scholarlms.com/
 * License:           GPL-2.0+
 * License URI:       http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain:       slms-sso
 * Domain Path:       /languages
 */

// If this file is called directly, abort.
if ( ! defined( 'WPINC' ) ) {
	die;
}

/**
 * Currently plugin version.
 * Start at version 1.0.0 and use SemVer - https://semver.org
 * Rename this for your plugin and update it as you release new versions.
 */
define( 'SLMS_SSO_VERSION', '3.0.0' );

/**
 * The code that runs during plugin activation.
 * This action is documented in includes/class-slms-sso-activator.php
 */
function activate_slms_sso() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-slms-sso-activator.php';
	Slms_Sso_Activator::activate();
}

/**
 * The code that runs during plugin deactivation.
 * This action is documented in includes/class-slms-sso-deactivator.php
 */
function deactivate_slms_sso() {
	require_once plugin_dir_path( __FILE__ ) . 'includes/class-slms-sso-deactivator.php';
	Slms_Sso_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_slms_sso' );
register_deactivation_hook( __FILE__, 'deactivate_slms_sso' );

/**
 * The core plugin class that is used to define internationalization,
 * admin-specific hooks, and public-facing site hooks.
 */
require plugin_dir_path( __FILE__ ) . 'includes/class-slms-sso.php';

/**
 * Begins execution of the plugin.
 *
 * Since everything within the plugin is registered via hooks,
 * then kicking off the plugin from this point in the file does
 * not affect the page life cycle.
 *
 * @since    1.0.0
 */
function run_slms_sso() {

	$plugin = new Slms_Sso();
	$plugin->run();

}
run_slms_sso();
