<?php
add_action('wp_ajax_slms_uuid_sync_step', function () {
    if (!current_user_can('manage_options')) {
        wp_send_json_error(['message' => 'Unauthorized']);
    }

    $offset = isset($_GET['offset']) ? intval($_GET['offset']) : 0;
    $method = ($_GET['method'] ?? 'email') === 'username' ? 'username' : 'email';
    $batchSize = 20;

    $moodle_url = 'https://yourmoodle.com/webservice/rest/server.php';
    $token = get_option('slmssso_ws_token');
    if (!$token) {
        wp_send_json_error(['message' => 'Moodle token not set in slmssso_ws_token']);
    }

    $get_users_fn = 'local_slmscommon_get_users_paginated';
    $set_uid_fn = 'local_slmscommon_update_user_uid';

    $params = [
        'wstoken' => $token,
        'wsfunction' => $get_users_fn,
        'moodlewsrestformat' => 'json',
        'offset' => $offset,
        'limit' => $batchSize
    ];

    $response = wp_remote_get($moodle_url . '?' . http_build_query($params));
    if (is_wp_error($response)) {
        wp_send_json_error(['message' => 'Failed to fetch users from Moodle']);
    }

    $users = json_decode(wp_remote_retrieve_body($response));
    if (!is_array($users) || empty($users)) {
        update_option('slms_uuid_sync_complete', true);
        wp_send_json_success(['done' => true]);
    }

    $synced = 0;
    foreach ($users as $user) {
        $lookup = $method === 'username' ? $user->username : $user->email;
        $wp_user = $method === 'username' ? get_user_by('login', $lookup) : get_user_by('email', $lookup);

        if (!$wp_user) continue;

        $uid = get_user_meta($wp_user->ID, 'uid', true);
        if (!$uid) {
            $uid = wp_generate_uuid4();
            update_user_meta($wp_user->ID, 'uid', $uid);
        }

        // Send UUID to Moodle
        $update_params = [
            'wstoken' => $token,
            'wsfunction' => $set_uid_fn,
            'moodlewsrestformat' => 'json',
            'userid' => $user->id,
            'uid' => $uid,
        ];

        $update_res = wp_remote_get($moodle_url . '?' . http_build_query($update_params));
        $update_body = json_decode(wp_remote_retrieve_body($update_res));

        if (isset($update_body->status) && $update_body->status === 'success') {
            $synced++;
        }
    }

    wp_send_json_success([
        'batch' => $synced,
        'next_offset' => $offset + $batchSize,
        'done' => false
    ]);
});
