<?php
if (!current_user_can('manage_options')) {
    wp_die('Unauthorized');
}
$method = isset($_GET['method']) && $_GET['method'] === 'username' ? 'username' : 'email';
?>
<div class="wrap">
    <h1>UUID Sync for LMS Users</h1>
    <p>This will generate UUIDs in WordPress for Moodle users (if missing) and sync them via profile field.</p>
    <p><strong>Matching method:</strong> <?php echo esc_html(ucfirst($method)); ?></p>

    <div id="uuid-sync-progress" style="border: 1px solid #ccc; padding: 10px; width: 100%; max-width: 600px;">
        <div id="uuid-sync-bar" style="height: 20px; width: 0; background: green;"></div>
    </div>
    <p id="uuid-sync-status">Starting sync...</p>
</div>

<script>
document.addEventListener('DOMContentLoaded', function () {
    let progress = 0;
    const bar = document.getElementById('uuid-sync-bar');
    const status = document.getElementById('uuid-sync-status');
    const method = "<?php echo esc_js($method); ?>";

    function syncStep(offset) {
        fetch(ajaxurl + '?action=slms_uuid_sync_step&offset=' + offset + '&method=' + method)
            .then(res => res.json())
            .then(data => {
                if (data.done) {
                    bar.style.width = '100%';
                    status.innerText = 'Sync completed';
                } else {
                    progress += data.batch;
                    bar.style.width = progress + '%';
                    status.innerText = 'Synced ' + progress + '%';
                    syncStep(data.next_offset);
                }
            });
    }

    syncStep(0);
});
</script>
